definition module EdCleanSystem;

/* OS dependent module for unix */

/* Interface module for calling the CLEAN compiler, code generator and linker */

import EdTypes, EdProgramState;

/*  Macros used to select platform specific code.
    Make sure only one of these macros is True.
*/
IfMacintoshSystem m o :== o;
IfMsWindowsSystem w o :== o;
IfUnixSystem u o :== u;

from UtilNewlinesFile import
	:: NewlineConvention(
	NewlineConventionNone,
	NewlineConventionMac, NewlineConventionUnix, NewlineConventionDos);
HostNativeNewlineConvention
	:== NewlineConventionUnix;

::	CompilerMsg
	= 	CompilerOK
	| 	SyntaxError
	| 	Patherror Pathname;

::	VerboseFun
	:== String -> ProgState -> * (IO -> ProgIO);
	
::	WindowFun
	:== Text -> ProgState -> * (IO -> ProgIO);
	
/* Compiles the given file:
	1st arg.	function to show verbose messages of the compiler.
	2nd arg.	function to show error and warning messages of the compiler.
	3rd arg.	function to show type info listed by the compiler.
	4th arg.	check syntax only?
	5th arg.	file name of the module to be compiled (must be a full .icl file name).
	6th arg.	list of paths where the compiler can find imported .dcl files.
	7th arg.	memory profile option for current project
	8th arg.	profile option for current project
	9th arg.	compiler options.
	10th arg.	program state.
	11th arg.	io state.
	1st result	new program and io state.
	2nd result	path name of the generated .abc file.
					Note: on the macintosh the .abc file is generated in the standard Clean System
					Files Folder. On Unix, however, the location of the .abc depends on the user
					settings.
	3rd result	indication whether compilation was successfull.
*/	
Compile	::	!VerboseFun !WindowFun !WindowFun !CompileOrCheckSyntax !CompileClearCache !Pathname !(List Pathname) !Bool !Bool !CompilerOptions !ProgState !IO
			-> (!ProgIO, !Pathname, !CompilerMsg);

/* Generates code for the given file:
	1st arg.	function to show error and warning messages of the code generator.
	2nd arg.	generate assembly only?
	3rd arg.	file name of the module to be compiled (must be a full .abc file name).
	4th arg.	code generator options.
	5th arg.	application options.
	6th arg.	program state.
	7th arg.	io state.
	1st result	new program and io state.
	2nd result	path name of the generated .o file.
					Note: on the macintosh the .o file is generated in the standard Clean System
					Files Folder. On Unix, however, the location of the .o depends on the user
					settings.
	3rd result	indication whether code generation was successfull.
*/	
CodeGen	::	!WindowFun !CodeGenerateAsmOrCode !Pathname !CodeGenOptions !ApplicationOptions !ProgState !IO
			-> (!ProgIO, !Pathname, !Bool);

/* Links the given file:
	1st arg.	function to show error and warning messages of the code generator.
	2nd arg.	full path name of the executable.
	3rd arg.	full path name of the '_system' object file.
	4th	arg.	full path names of all the object files.
	5th arg.	default paths.
	6th arg.	application settings.
	7th arg.	program state.
	8th arg.	io state.
	1st	result	new program and io state.
	2nd result	indication whether linking was successfull.
*/
Link ::	!WindowFun !Pathname !Pathname !(List Pathname) !(List Pathname) !ApplicationOptions !Processor !LinkOptions !(List Pathname) !(List Pathname) !ProgState !IO
		 -> (!ProgIO,!Bool);
ApplicationOptionsToFlags :: !ApplicationOptions -> Int;
FlagsToApplicationOptions :: !Int !ApplicationOptions -> ApplicationOptions;
	
Execute	::	!WindowFun !Pathname !ApplicationOptions !ProgState !IO
			-> (!ProgIO, !Bool);

ClearCompilerCache :: !IO -> (!Int,!IO);
QuitCleanCompiler :: !IO -> IO;
ExitCleanCompiler :: !ProgState !IO -> ProgIO;


SetClipboardText :: String (IOState s) -> (IOState s);
GetClipboardText :: (IOState s)        -> (String, IOState s);

SystemDependentDevices :: [DeviceSystem ProgState IO];
SystemDependentInitialIO :: InitialIO ProgState;

EditorDefaultFontsToTry :: [(!FontName, ![FontStyle], !FontSize)];

ReadStartupInfo :: !{#Char} !*Files -> (!StartupInfo,!*Files);
